<?php
session_start();
require 'authenticate.user.php';

require 'configuration.php';
require_once 'includes/common.functions.php';
require_once ('classes/database.php');
require_once ('classes/functions.php');
$sqlObj = new mysqlClass;
$funcObj = new funcClass;
$table = "##campaigns"; 
$curFile = basename(__FILE__);
$ACTION				= 'add';

if ($_SESSION['IS_USER_CLIENT'])
{
	die ("Sorry, you are not authorized to access this page");
}

require_once ('includes/validate.campaigns.php');
$show = isset($_GET['show']) ? $_GET['show'] : '';

// Query for unsent campaigns
$query = "SELECT CAMPAIGN_NAME, SUBJECT, DATE_CREATED FROM
##campaigns WHERE IS_SENT = '0' ORDER BY ID DESC
LIMIT 0, 5";

$unsentCampaigns = array();
$unsentCampaigns = $funcObj->CustomQuery($query);

// Query for sent campaigns
$query = "SELECT A.ID AS ID, A.CAMPAIGN_NAME AS CAMPAIGN_NAME, A.DATE_SENT AS DATE_SENT, COUNT(B.EMAIL) AS CLICKS FROM
##campaigns AS A, ##report AS B WHERE A.IS_SENT = '1' AND B.ACTION='track' 
GROUP BY A.ID ORDER BY A.ID DESC
LIMIT 0, 5";

$sentCampaigns = array();
$sentCampaigns = $funcObj->CustomQuery($query);

/* ACTIVATE THE TAB */
$activeTab = 'Overview';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Welcome to Segnant Mailer</title>
<link rel="stylesheet" href="includes/css/themes/blue/style.css" type="text/css" media="print, projection, screen" />
<link rel="stylesheet" type="text/css" href="includes/css/segnantmailer.css" />
<script type="text/javascript" src="includes/js/jquery-1.3.2.min.js"></script>
<script type="text/javascript" src="includes/js/jquery.tablesorter.js" ></script>
<script type="text/javascript" src="includes/js/jquery.corner.js"></script>
<script type="text/javascript" src="includes/js/common.jquery.js"></script>
<script type="text/javascript">
$(document).ready(function() {
if (!$.browser.msie)
{
$('#roundDiv1').corner("round 7px");
$('#roundDiv2').corner("round 7px");
}
});
</script>
<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
<style type="text/css">
div#roundDiv1, div#roundDiv2 { background: url('images/rounder-corner-bg.png') repeat-x; width: auto; padding: 10px; }
</style>
</head>
<body>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td height="79" class="headerbg"><?php require_once 'includes/inc.header.php' ?>    
    </td>
  </tr>

  <tr>
    <td class="canvas" height="300" valign="top"><table width="100%" border="0" cellspacing="10" cellpadding="4">
      <tr>
        <td colspan="2" class="heading" height="50" valign="top">Overview</td>
        </tr>
        <tr>
        <td colspan="2">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
          <tr>
            <td width="10" valign="top"><img src="images/desktop_boxleft.png" alt="" /></td>
            <td class="desktopbox" valign="top"  ><table width="100%" border="0" cellspacing="0" cellpadding="0" class="tablebox">
              <tr>
                <td height="118" width="24%" class="desktopboxhd" valign="middle"><img src="images/icons/icon_create_campaign.png" alt="" hspace="5" align="absmiddle"  /> <span>Create Campaign</span></td>
                <td rowspan="3" class="desktopboxborder" >&nbsp;</td>
                <td width="24%" class="desktopboxhd" valign="middle"><img src="images/icons/icon_addressbook.png" alt="" hspace="5" align="absmiddle"  /> <span>Add Contacts</span></td>
                <td rowspan="3" class="desktopboxborder">&nbsp;</td>
                <td width="24%" class="desktopboxhd" valign="middle"><img src="images/icons/icon_send.png" alt="" hspace="5" align="absmiddle"  /> <span>Start Sending</span></td>
                <td rowspan="3" class="desktopboxborder">&nbsp;</td>
                <td width="24%" class="desktopboxhd" valign="middle"><img src="images/icons/icon_report.png" alt="" hspace="5" align="absmiddle"  /> <span>Check Reports</span></td>
              </tr>
              <tr>
                <td valign="top" height="97" class="desktopbox_desc">
                  Create a new campaign, manage unsent campaigns and see sent campaigns. Follow the simple easy to use wizard to add a new campaign.</td>
                <td valign="top" class="desktopbox_desc">Create new address book or manage existing address books. Bulk import addresses from CSV into a new or already available address book.</td>
                <td valign="top" class="desktopbox_desc">Your campaign and address book is ready. Now its a time for test sending, proofing and sending the campaign to actual recipients.</td>
                <td valign="top" class="desktopbox_desc">
                  Check various reports to see how successful your campaign was.</td>
              </tr>
              <tr>
                <td height="55" align="center"><a href="campaigns.php"><img src="images/btn_gothere.jpg" alt="" border="0" class="ro" /></a></td>
                <td align="center"><a href="addressbook.php"><img src="images/btn_gothere.jpg" alt="" border="0" class="ro" /></a></td>
                <td align="center"><a href="campaigns.php"><img src="images/btn_gothere.jpg" alt="" border="0" class="ro" /></a></td>
                <td align="center"><a href="reports.php"><img src="images/btn_gothere.jpg" alt="" border="0" class="ro" /></a></td>
              </tr>
            </table></td>
            <td width="10"  valign="top"><img src="images/desktop_boxright.png" alt="" /></td>
          </tr>
        </table>

        </td>
        </tr>
      <tr>
        <td width="50%" valign="top">
        <div id="roundDiv1" style="border: 3px solid #a4a4a4">
        <table width="100%" border="0" cellspacing="6" cellpadding="2" >
        <tr>
        <td class="size16 bold"><img src="images/icons/email_recent_created.png" alt="" border="0" align="absmiddle" /> &nbsp;Campaigns created recently</td>
        </tr>
        <tr>
        <td>
       <table cellspacing="1" class="tablesorter" style="margin-top: 10px;"> 
            <thead>
            <tr>
              <th width="30" align="center">#</th>
              <th align="left" width="90">Date Saved</th>
              <th width="25%" align="left">Name</th>
              <th align="left">Subject</th>
            </tr>
            </thead>
            <tbody>
        <?php
        $i=0;
		if(count($unsentCampaigns)!=0)
		{
			foreach ($unsentCampaigns as $row)
			{
				$i++;
				echo "<tr>";
				echo "
				<td align='center' style='vertical-align: middle; height: 34px;'>{$i}</td>
				<td align='left' style='vertical-align: middle; height: 34px;'>";
					echo date("M j, Y", strtotime($row['DATE_CREATED']));
				echo "</td>
				<td align='left' style='vertical-align: middle; height: 34px;' >{$row['CAMPAIGN_NAME']}</td>
				<td align='left' style='vertical-align: middle; height: 34px;'>{$row['SUBJECT']}</td>";
				echo "</tr>";
			}
		}
		else
		{
			echo "<tr><td colspan='4' align='center' height='34' valign='middle' class='row0'>No unsent campaigns found... </td></tr>";
		}
		?>
        </tbody>
		</table>
        <?php
		if (count($unsentCampaigns))
		{
			echo "<div style='float: right; padding-right:6px; height: 6px;'><a href='campaigns.php' class='bold' >View all</a></div>";
		}	
		?>
        </td>
        </tr>
        </table>
        </div>
        </td>
        <td width="50%" valign="top">
        <div id="roundDiv2" style="border: 3px solid #a4a4a4">
        <table width="100%" border="0" cellspacing="6" cellpadding="2">
        <tr>
        <td class="size16 bold"><img src="images/icons/email_recent_sent.png" alt="" border="0" align="absmiddle" /> &nbsp;Campaigns sent recently</td>
        </tr>
        <tr>
        <td>
        <table cellspacing="1" class="tablesorter" style="margin-top: 10px;"> 
            <thead>
            <tr>
              <th width="30" align="center">#</th>
              <th align="left" width="90">Date Sent</th>
              <th align="left">Name</th>
              <th align="right" width="10%">Clicks</th>
              <th align="center" width="10%">Reads</th>
              <th align="center" width="15%">Recent Open</th>
            </tr>
            </thead>
        <?php
        $i=0;
		if(count($sentCampaigns)!=0)
		{
			foreach ($sentCampaigns as $row)
			{
				
				$totalViews 	= 0;
				
				$query 			= "SELECT COUNT(DISTINCT(EMAIL)) AS VIEWS FROM ##report WHERE CAMPAIGN_ID = '{$row["ID"]}' AND ACTION='view'";
				$totalViews		= $funcObj->CustomQueryCount($query);
				
				$query 			= "SELECT COUNT(EMAIL) AS CLICKS FROM ##report WHERE CAMPAIGN_ID = '{$row["ID"]}' AND ACTION='track'";
				$totalClicks	= $funcObj->CustomQueryCount($query);
				$totalClicks    = $totalClicks[0]['CLICKS'];
				$query			= "SELECT DATE_TIME AS RECENT_OPEN FROM ##report WHERE CAMPAIGN_ID = '{$row["ID"]}' AND ACTION='view' ORDER BY ID DESC LIMIT 1";
				$recentOpen		= array();
				$recentOpen 	= $funcObj->CustomQueryArray($query);
				
				$query			= "SELECT COUNT(DISTINCT(C.EMAIL)) AS COUNT 
									FROM smlr_contacts AS C, 
									smlr_addressbook AS A,
									smlr_campaign_send_stats AS B 
									WHERE 
									C.ADDR_ID = A.ID AND C.IS_USED = '1'
									AND B.ADDR_ID = A.ID
									AND B.CAMPAIGN_ID = '{$row["ID"]}'";
				$totalEmails	= array();
				
				$totalEmails 	= $funcObj->CustomQueryArray($query);
				
				$query 			= "SELECT COUNT(DISTINCT(EMAIL)) AS COUNT FROM ##report WHERE CAMPAIGN_ID = '{$row["ID"]}' AND ACTION IN ('hardbounce','softbounce')";
				$totalBounce	= $funcObj->CustomQueryCount($query);
				
				if (count($totalEmails))
				{
					$totalEmailsNum = $totalEmails[0]['COUNT'];
				}
				else
				{
					$totalEmailsNum	= 0;
				}
				if (count($totalBounce))
				{
					$totalBounceNum = $totalBounce[0]['COUNT'];
				}
				else
				{
					$totalBounceNum	= 0;
				}
				
				if (count($totalViews))
				{
					$totalViewsNum = $totalViews[0]['VIEWS'];
				}
				else
				{
					$totalViewsNum	= 0;
				}
				
				
				$totalEmailsSent = $totalEmailsNum - $totalBounceNum;
				
				if ($totalEmailsSent < 1)
					$totalEmailsSent = 0;
				
				if (count($recentOpen))
				{
					$recentOpenStr = date("M j, Y", strtotime($recentOpen[0]['RECENT_OPEN']));
					$recentOpenStr .= '<br /><small style="color: #696969">' . date("g:i:s a", strtotime($recentOpen[0]['RECENT_OPEN'])) . '</small>';
				}
				else
				{
					$recentOpenStr = 'Never';
				}
				
				/* Calculate bar graph image width */
				$safeTotalViews 		= $totalViewsNum;
				$safeTotalEmailsSent 	= $totalEmailsSent; 
				if ($totalViewsNum < 1)
					$safeTotalViews = 1;
				
				if ($totalEmailsSent < 1)
					$safeTotalEmailsSent = 1;
				
				if ($totalViewsNum > 0)
					$BarGraphImgWidth	= ceil((($safeTotalViews / $safeTotalEmailsSent ) * 100)/2);
				else
					$BarGraphImgWidth = 0;
				
				/* Graph Bug Fix */
				if ($BarGraphImgWidth > 50)
					$BarGraphImgWidth = 50;
				 					
				$imgTitle			= $totalViewsNum .' out of ' . $safeTotalEmailsSent;
				//{$totalViews} / {$totalEmailsSent}
				$i++;
				echo "<tr>";
				echo "
				<td align='center' style='vertical-align: middle'>{$i}</td>
				<td align='left' style='vertical-align: middle'>";
					echo date("M j, Y", strtotime($row['DATE_SENT']));
				echo "</td>
				<td align='left' style='vertical-align: middle'>{$row['CAMPAIGN_NAME']}</td>
				<td align='right' style='vertical-align: middle'>{$totalClicks}</td>
				<td align='center' style='vertical-align: middle'><div style='width:50px; border: 1px solid #999;text-align: left;' title='{$imgTitle}'><img src='images/green_bar.gif' height='8' width='{$BarGraphImgWidth}' title='{$imgTitle}' /></div></td>
				<td align='center' nowrap='nowrap' height='33'>{$recentOpenStr}</td>";
				echo "</tr>";
			}
		}
		else
		{
			echo "<tr><td colspan='6' align='center' height='34' valign='middle' class='row0'>No sent campaigns found... </td></tr>";
		}
		?>
		</table>
        <?php
		if (count($sentCampaigns))
		{
			echo "<div style='float: right; padding-right:6px; height: 6px;'><a href='campaigns.php?show=sent' class='bold' >View all</a></div>";
		}	
		?>
        </td>
        </tr>
        </table>
        </div>
        </td>
      </tr>
    </table></td>
  </tr>
<?php require_once 'includes/inc.footer.php' ?>
</table>
</body>
</html>
