<?php

class ExcelWriterXML_Worksheet {
    private $name;
    private $rows = [];

    public function __construct($name) {
        $this->name = $name;
    }

    public function addRow($cells) {
        $this->rows[] = $cells;
    }

    public function getWorksheetXML() {
        $xml = '<Worksheet ss:Name="' . $this->name . '">' . "\n";
        $xml .= '<Table>' . "\n";
        foreach ($this->rows as $row) {
            $xml .= '<Row>' . "\n";
            foreach ($row as $cell) {
                $xml .= '<Cell';
                if (isset($cell['style'])) {
                    $xml .= ' ss:StyleID="' . $cell['style'] . '"';
                }
                $xml .= '><Data ss:Type="' . $cell['type'] . '">' . $cell['data'] . '</Data></Cell>' . "\n";
            }
            $xml .= '</Row>' . "\n";
        }
        $xml .= '</Table>' . "\n";
        $xml .= '</Worksheet>' . "\n";
        return $xml;
    }
}
?>
