// JavaScript Document

function confirmAction(message, targetURL)

{

	if (confirm(message))

	{

		window.location.href=targetURL;	

	}

}



jQuery(document).ready(function() {

	jQuery('#changepasswordLink').click(function(){

		jQuery('.changepassword').val('');

		jQuery('#changepassword').slideToggle('slow');

		jQuery('#passworderror').hide();

	})



	jQuery('#resetbutton').click(function() {

		removeErrorClass();

		jQuery('#changepassword').slideUp('slow');

		return false;

	})

	

	jQuery('.changepassword').focus(function()

	{

		removeErrorClass();

	})

	

	PEPS.rollover.init();

});





PEPS = {};



PEPS.rollover =

{

   init: function()

   {

      this.preload();

     

      jQuery(".ro").hover(

         function () { jQuery(this).attr( 'src', PEPS.rollover.newimage(jQuery(this).attr('src')) ); },

         function () { jQuery(this).attr( 'src', PEPS.rollover.oldimage(jQuery(this).attr('src')) ); }

      );

   },



   preload: function()

   {

      jQuery(window).bind('load', function() {

         jQuery('.ro').each( function( key, elm ) { jQuery('<img>').attr( 'src', PEPS.rollover.newimage( jQuery(this).attr('src') ) ); });

      });

   },

   

   newimage: function( src )

   {

      return src.substring( 0, src.search(/(\.[a-z]+)$/) ) + '_o' + src.match(/(\.[a-z]+)$/)[0];

   },



   oldimage: function( src )

   {

      return src.replace(/_o\./, '.');

   }

};



function removeErrorClass()

{

		jQuery('#txtoldpassword').removeClass('changepassworderror');

		jQuery('#txtnewpassword').removeClass('changepassworderror');

		jQuery('#txtrepassword').removeClass('changepassworderror');

		jQuery('#passworderror').removeClass('passwordnoerror');

		jQuery('#passworderror').addClass('passworderror');

		jQuery('#passworderror').hide('slow');

		jQuery('#passworderror').html('');

}



function cleanOnTimeout()

{

		jQuery('#txtoldpassword').removeClass('changepassworderror');

		jQuery('#txtnewpassword').removeClass('changepassworderror');

		jQuery('#txtrepassword').removeClass('changepassworderror');

		jQuery('#changepassword').slideUp('slow');	

}



// Submit the change password form

function submitchangepassword()

{

	var passwderror	= '';

	var oldPassword = escape(jQuery('#txtoldpassword').val());

	var newPassword = escape(jQuery('#txtnewpassword').val());

	var confirmPass = escape(jQuery('#txtrepassword').val());

	jQuery('#passworderror').removeClass('passwordnoerror');

	jQuery('#passworderror').addClass('passworderror');

	

	if (oldPassword == '')

	{

		passwderror += 'Old password is required.<br />';	

		jQuery('#txtoldpassword').addClass('changepassworderror');

	}

	if (newPassword.length < 6)

	{

		passwderror += 'New password must be atleast 6 characters long.<br />';	

		jQuery('#txtnewpassword').addClass('changepassworderror');

	}

	else if (newPassword != confirmPass)

	{

		passwderror += 'Password mis-match.<br />';	

		jQuery('#txtrepassword').addClass('changepassworderror');

	}

	

	if (passwderror.length > 0)

	{

		jQuery('#passworderror').html(passwderror);

		jQuery('#passworderror').show('slow');

		return false;

	}

	else // js validation passed, now send ajax request to change the password

	{

		jQuery.ajax({

			type: "GET",

			url: "changepassword.ajax.php",

			data: "oldpass=" + oldPassword + "&newpass=" + newPassword + "&confirmpass=" + confirmPass,

			error: function(){

				jQuery('#preloader').html("<small>Enter the e-mail address you registered with and hit Retrieve Password button</small>");

			},

			success: function(html){

				// If length is more than 1 character th

				if (html == '1') 

				{

					jQuery('#passworderror').addClass('passwordnoerror');

					jQuery('#passworderror').html('Password has been updated successfully!');

					jQuery('#passworderror').show('slow');

					// automatically close the popup after 3 seconds.

					setTimeout("cleanOnTimeout()", 3000);

					return false;

				}

				else

				{

					jQuery('#passworderror').html(html);

					jQuery('#passworderror').show('slow');

					return false;

				}

			}

		});

	}

	

	return false;

}

