<?php
/* 
------------------------------------------------------------------------------------
					Sample code for cut and paste
------------------------------------------------------------------------------------


To make "Total : 4    Displaying: 1-5 "
**************************************
		$pageObj->showPageInfo();

To make "Pages: 1 2 3 4 "
**************************************
		$pageObj->show("http://chd-wrkstn-010/public/Ingenuity/documentation/dhatt/index.php?option=com_traverse_cat&Itemid=$itemid&id=$catID");

------------------------------------------------------------------------------------
*/

class Paging
{
	var $ERROR = '';
	var $start = null;
	var $limit = null;
	var $totalRecords = null;
	var $displayPages	 = null;

	//***************** Start of constructor() *******************************
	
	function Paging( $totalRecords, $start, $limit, $displayPages=10 )
	{
	
		$this->totalRecords = intval( $totalRecords );
		$this->start		= intval( $start );
		$this->limit		= intval( $limit );
		$this->displayPages	= intval( $displayPages );
		return $this;
	}

	//***************** End of constructor() ***********************************

	//***************** Start of show() ***********************************
	
	function Show($link)
	{
		$txt ='';
		if(!empty($this->totalRecords))
		{
			$txt = '<div class="pagingDiv"><strong>Pages: </strong>';
			$displayPages =$this->displayPages;
			$totalPages = ceil( $this->totalRecords / $this->limit );
			$currentPage = ceil( ($this->start+1) / $this->limit );
			
			 $temp = floor($displayPages/2);
			 $start_loop = $currentPage - $temp;
			
			if($start_loop > $totalPages - $displayPages)
				$start_loop = $totalPages - $displayPages;
			if($start_loop == $totalPages - $displayPages)
				$start_loop = $totalPages - $displayPages + 1;

			if($start_loop < 1)
				$start_loop = 1;

			//$start_loop = (floor(($currentPage-1)/$displayPages))*$displayPages+1;
			if($start_loop + $displayPages - 1 < $totalPages)
				$stop_loop = $start_loop + $displayPages - 1;
			else
				$stop_loop = $totalPages;
			
			//$link .= '&amp;limit='. $this->limit;
			if(strpos($link, 'start='))
				$link = substr($link, 0,strrpos($link, '&start'));
			
			if($totalPages > 1)
			{
				for ($i=$start_loop; $i <= $stop_loop; $i++)
				{
					$page = ($i - 1) * $this->limit;
					if ($i == $currentPage)
						$txt .= '<span class="currentPage">'. $i .'</span>';
					else
						$txt .= '<span class="pages"><a href="'. ( $link .'&amp;start='. $page ) .'" class="pagenav">'. $i .'</a></span>';
				}
			}
			else
				$txt = ''; 
		}
		if ($txt != "")
			return $txt . '&nbsp;&nbsp;</div>';
		else
			return $txt . '';	
	}

	//***************** End of show() *************************************
	//***************** Start of showPageInfo() ***********************************
	
	function ShowPageInfo()
	{
	
		$txt = '&nbsp;&nbsp;<strong>Total: ' . $this->totalRecords.'</strong>';
		
		if($this->totalRecords < $this->limit)
			$txt .= '<strong> | Displaying: ' . ($this->start+1) . '-' . ($this->start+$this->totalRecords) . '</strong>&nbsp;';
		elseif(($this->totalRecords - $this->limit) < $this->start)
			$txt .= '<strong> | Displaying: ' . ($this->start+1) . '-' . $this->totalRecords . '</strong>&nbsp;';
		else
			$txt .= '<strong> | Displaying: ' . ($this->start+1) . '-' . ($this->start+$this->limit) . '</strong>&nbsp;';
		
		return $txt;
	}

	//***************** End of showPageInfo() *************************************
}// End of class paging
?>
